/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.Iterator;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.NavBeacon;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;

public class TileEntityBeacon
extends TileEntityDecor {
    public NavBeacon currentBeacon;
    public static final String BEACON_NAME_TEXT_KEY = "Beacon Name";
    public static final String BEACON_GLIDESLOPE_TEXT_KEY = "Glide Slope (Deg)";
    public static final String BEACON_BEARING_TEXT_KEY = "Bearing (Deg)";

    public TileEntityBeacon(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        Iterator iterator = this.text.keySet().iterator();
        if (iterator.hasNext()) {
            JSONText textDef = (JSONText)iterator.next();
            this.currentBeacon = NavBeacon.getByNameFromWorld(world, (String)this.text.get(textDef));
            return;
        }
    }

    @Override
    public void destroy(BoundingBox box) {
        super.destroy(box);
        if (this.currentBeacon != null) {
            NavBeacon.removeFromWorld(this.world, this.currentBeacon.name);
        }
    }

    @Override
    public void updateText(String textKey, String textValue) {
        if (this.currentBeacon != null) {
            NavBeacon.removeFromWorld(this.world, this.currentBeacon.name);
            this.currentBeacon = null;
        }
        try {
            String beaconName = null;
            String glideslope = null;
            String bearing = null;
            for (Map.Entry textEntry : this.text.entrySet()) {
                String entryKey = ((JSONText)textEntry.getKey()).fieldName;
                if (entryKey == null) continue;
                switch (entryKey) {
                    case "Beacon Name": {
                        beaconName = (String)textEntry.getValue();
                        break;
                    }
                    case "Glide Slope (Deg)": {
                        glideslope = (String)textEntry.getValue();
                        break;
                    }
                    case "Bearing (Deg)": {
                        bearing = (String)textEntry.getValue();
                    }
                }
            }
            switch (textKey) {
                case "Beacon Name": {
                    beaconName = textValue;
                    break;
                }
                case "Glide Slope (Deg)": {
                    glideslope = textValue;
                    break;
                }
                case "Bearing (Deg)": {
                    bearing = textValue;
                }
            }
            this.currentBeacon = new NavBeacon(this.world, beaconName, Double.parseDouble(glideslope), Double.parseDouble(bearing), this.position);
            super.updateText(textKey, textValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

